<?php

/**
 * Class Auth
 * Checks if user is logged in
 */
class Auth
{
    public static function isAuthenticated()
    {
        //print_r($_POST);
        //if POST request - verify access is valid
        if($_SERVER['REQUEST_METHOD']==="POST"){
           $access =  isset($_POST['access'])?$_POST['access']:'';
           $results=self::checkAuthentication($access);
           $selectedvehicle=session::get('vehicleid');
           if(isset($_POST['selectedvehicle']))$selectedvehicle=$_POST['selectedvehicle'];
           Session::set('vehicleid',$selectedvehicle);
           //echo Session::get('vehicleid');
           //exit;
           return $results;

        }
        else{
           //not post request
           echo "unable to authenticate";
           redirect::home();
           exit;
        }
    }

    public static function checkAuthentication($access)
    {
        $results="";
        try{
           $results=Jwt::decode($access);
        }
        catch(exception $e){
           echo "not authorised";
           echo $e->getMessage();
           redirect::home();
           //exit();
           //IndexController::logout();
           /*Session::destroy();
           header('location: ' . Config::get('URL'));
           exit;*/

        }
        return $results;
    }

    /**
     * The admin authentication flow, just check if the user is logged in (by looking into the session) AND has
     * user role type 7 (currently there's only type 1 (normal user), type 2 (premium user) and 7 (admin)).
     * If user is not, then he will be redirected to login page and the application is hard-stopped via exit().
     * Using this method makes only sense in controllers that should only be used by admins.
     */
    public static function checkAdminAuthentication()
    {
        // initialize the session (if not initialized yet)
        Session::init();

        // self::checkSessionConcurrency();

        // if user is not logged in or is not an admin (= not role type 7)
        if (!Session::userIsLoggedIn() || Session::get("user_account_type") != 7) {
            // ... then treat user as "not logged in", destroy session, redirect to login page
            Session::destroy();
            header('location: ' . Config::get('URL') . 'login');
            // to prevent fetching views via cURL (which "ignores" the header-redirect above) we leave the application
            // the hard way, via exit(). @see https://github.com/panique/php-login/issues/453
            // this is not optimal and will be fixed in future releases
            exit();
        }
    }

    /**
     * Detects if there is concurrent session (i.e. another user logged in with the same current user credentials),
     * If so, then logout.
     */
    public static function checkSessionConcurrency(){
        if(Session::userIsLoggedIn()){
            if(Session::isConcurrentSessionExists()){
                LoginModel::logout();
                Redirect::home();
                exit();
            }
        }
    }
}